// Memory.cpp: implementation of the CMemory class.
//
//////////////////////////////////////////////////////////////////////

#include "Memory.h"
#include "GBMachine.h"
#include "interrupt.h"
#include "Input.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


CMemory::CMemory()
{
	m_bExternRAMEnabled = true; //???????
	m_nRAMBankNum = 0; //????

	m_pMachine = NULL;
	m_pInterrupt = NULL;
	m_pCPU = NULL;

//	InitMemory();
}

CMemory::~CMemory()
{

}

//////////////////////////////////////////////////////////////////////////

void CMemory::InitMemory()
{
	memset(m_VideoRAM, 0, 0x4000);
	m_EXRAM.Memset_Random();
	memset(m_IOPorts, 0, 0x80);
	memset(m_HighRAM, 0, 0x80);
	//memset_rand(mem->WorkRAM , 0x1000);

	m_IOPorts[STAT_REG-0xFF00] = 0x02;

	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////

	Write8(IF_REG,0xE0); //Load mask
	
	//LOAD INITIAL VALUES TO RAM
	
	Write8(TIMA_REG,0x00);
	Write8(TMA_REG,0x00);
	m_IOPorts[TAC_REG-0xFF00] = 0x00;//Write8(TAC_REG,0x00);
	
	//Sound registers are inited in GB_SoundInit()
	
	Write8(LCDC_REG,0x91);
	
	Write8(SCY_REG,0x00);
	Write8(SCX_REG,0x00);
	
	m_IOPorts[LYC_REG-0xFF00] = 0x00;//Write8(LYC_REG,0x00);
	
	Write8(BGP_REG,0xFC);
	Write8(OBP0_REG,0xFF);
	Write8(OBP1_REG,0xFF);
	
	Write8(WY_REG,0x00);
	Write8(WX_REG,0x00);
	
// 	GameBoy.Memory.InterruptMasterEnable = 0;
// 	GameBoy.Memory.RAMEnabled = 0;
	
	Write8(0xFF72,0x00);
	Write8(0xFF73,0x00);
	
	Write8(0xFF6C,0xFE);
	
	Write8(0xFF75,0x8F);
	
	Write8(0xFF76,0x00);
	Write8(0xFF77,0x00);

	m_IOPorts[DIV_REG-0xFF00] = 0xAF;
	m_IOPorts[LY_REG-0xFF00] = 0x00;

	CompareLYC2LY();
	
#if 0
	if(GameBoy.Emulator.CGBEnabled == 1)
	{
		mem->IO_Ports[LY_REG-0xFF00] = 0x90;
		
		Write8(0xFF74,0x00);
		
		Write8(SVBK_REG,0xF8);
		Write8(VBK_REG,0xFE);
		
		mem->IO_Ports[DIV_REG-0xFF00] = 0x22;
		
		mem->IO_Ports[HDMA5_REG-0xFF00] = 0xFF;
		GameBoy.Emulator.HDMAenabled = HDMA_NONE;
		GameBoy.Emulator.HBlankHDMAdone = 0;
        GameBoy.Emulator.gdma_preparation_time_countdown = -1;
		
		//PALETTE RAM
		u32 i;
		for(i= 0; i < 64; i++)
		{
			GameBoy.Emulator.bg_pal[i] = 0xFF;
			GameBoy.Emulator.spr_pal[i] = rand() & 0xFF;
		}
	}
#endif
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
#include "Memory.in"


void CMemory::DumpDebugInfo()
{
	NMGB_DEBUG_PRINT(NMGB_DEBUG_COLOR_WHITE,"LCDC:%02x,\tSTAT:%02x,\tSCY:%02x,\tSCX:%02x",
		ReadReg8(LCDC_REG),ReadReg8(STAT_REG),ReadReg8(SCY_REG),ReadReg8(SCX_REG));

	NMGB_DEBUG_PRINT(NMGB_DEBUG_COLOR_WHITE,"LY:%02x,\tLYC:%02x,\tDMA:%02x,\tWY:%02x,\tWX:%02x",
		ReadReg8(LY_REG),ReadReg8(LYC_REG),ReadReg8(DMA_REG),ReadReg8(WY_REG),ReadReg8(WX_REG));


	NMGB_DEBUG_PRINT(NMGB_DEBUG_COLOR_WHITE,"BGP:%02x,\tOBP0:%02x,\tOBP1:%02x,\tP1:%02x,\tSB:%02x",
		ReadReg8(BGP_REG),ReadReg8(OBP0_REG),ReadReg8(OBP1_REG),ReadReg8(P1_REG),ReadReg8(SB_REG));

	NMGB_DEBUG_PRINT(NMGB_DEBUG_COLOR_WHITE,"SC:%02x,\tDIV:%02x,\tTIMA:%02x,\tTMA:%02x,\tTAC:%02x",
		ReadReg8(SC_REG),ReadReg8(DIV_REG),ReadReg8(TIMA_REG),ReadReg8(TMA_REG),ReadReg8(TAC_REG));

	NMGB_DEBUG_PRINT(NMGB_DEBUG_COLOR_WHITE,"IE::%02x,\tIF:%02x,\tIME:%d",
	Read8(IE_REG),ReadReg8(IF_REG),m_pMachine->IME()?1:0);
}
