//////////////////////////////////////////////////////////////////////
// c_gao 2007-9-14
// ˫Գ
//////////////////////////////////////////////////////////////////////

//#define _PLATFORM_3DS_ //has been defined in config.h

//#include <3ds.h>


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "platform.h"
#include "cartridge.h"
#include "Memory.h"
#include "Z80m.h"
#include "interrupt.h"
#include "config.h"
#include "gameboy.h"
#include "mbc.h"
#include "GBMachine.h"
#include "Input.h"
#include "Kwirk_gb.h"
#include "DMG_ROM_bin.h"
#include "memfunc.h"
#include "font8.h"


char* file;

u32			g_Key[4];
bool FB_OK = false;
CCartridge	g_Cart;



//////////////////////////////////////////////////////////////////////////
//GameInit()
//////////////////////////////////////////////////////////////////////////
void GameInit()
{

	//g_configinfo.m_sInnerRomFile = (char*)DMG_ROM_bin;
	//g_configinfo.m_bLoadInnerROM = true;

	g_Cart.LoadRomFile((const char*)Kwirk_gb);

}

//////////////////////////////////////////////////////////////////////////
//GameLoop()
//////////////////////////////////////////////////////////////////////////
void GameLoop(u8* buffer)
{
	//memset(buffer+/*24*256+48*/6192, 0, /*256*192*2*/36768);
	
	g_pGameBoy->SetFrameBuffer(buffer,buffer);
	//g_pGameBoy->m_pFrameBuffer[0] = buffer;
	//g_pGameBoy->m_pFrameBuffer[1] = buffer;

	g_pGameBoy->SetKeyState(0, /*ks*/g_Key[0]);

	while(!FB_OK)
		g_pGameBoy->Start();
	/*	
	u32 color=0x294a;//g_pGameBoy->GetGray(0);
	iprintf("%4x\n",color|BIT(15));
	for(int i=0; i<1000; i++)
		buffer[i] = (u16)color|BIT(15);//((u16)color)|BIT(15);
	*/
	FB_OK = false;	
}

//////////////////////////////////////////////////////////////////////////
//SetKeyState()
//////////////////////////////////////////////////////////////////////////
int SetKeyState()
{
	hidScanInput();	
	u32 keys = hidKeysHeld();//hidKeysDown();
	
	if ((keys & KEY_R) && (keys & KEY_L))
			return -1; // break in order to return to hbmenu;
	
	if(keys & KEY_LEFT)
		g_Key[0] |= NMGB_KEY_LEFT;
	else
		g_Key[0] &= ~NMGB_KEY_LEFT;
		
	if(keys & KEY_RIGHT)
		g_Key[0] |= NMGB_KEY_RIGHT;
	else
		g_Key[0] &= ~NMGB_KEY_RIGHT;
		
	if(keys & KEY_UP)
		g_Key[0] |= NMGB_KEY_UP;
	else
		g_Key[0] &= ~NMGB_KEY_UP;				
		
	if(keys & KEY_DOWN)
	{
		g_Key[0] |= NMGB_KEY_DOWN;
		//iprintf("AA\n");
	}
	else
		g_Key[0] &= ~NMGB_KEY_DOWN;
		
	if(keys & KEY_START)
		g_Key[0] |= NMGB_KEY_START;
	else
		g_Key[0] &= ~NMGB_KEY_START;		
		
	if(keys & KEY_SELECT)
		g_Key[0] |= NMGB_KEY_SELECT;
	else
		g_Key[0] &= ~NMGB_KEY_SELECT;	
		
	if(keys & KEY_A)
		g_Key[0] |= NMGB_KEY_A;
	else
		g_Key[0] &= ~NMGB_KEY_A;	
		
	if(keys & KEY_B)
		g_Key[0] |= NMGB_KEY_B;
	else
		g_Key[0] &= ~NMGB_KEY_B;									
		
	return 0;
}
//////////////////////////////////////////////////////////////////////////
//main()
//////////////////////////////////////////////////////////////////////////
int main(void) 
{
	// Initialize services
	srvInit();
	aptInit();
	hidInit(NULL);
	gfxInit();
	//gfxSet3D(true); // uncomment if using stereoscopic 3D
	
	GameInit();
	
			gspWaitForVBlank();

		// Example rendering code that displays a white pixel
		// Please note that the 3DS screens are sideways (thus 240x400 and 240x320)
		u8* fb = gfxGetFramebuffer(GFX_TOP, GFX_LEFT, NULL, NULL);
		memset(fb, 0, 240*400*3);
		int offset = (120*240+48+144)*3;
		CRGBA text_clr(0,255,0,0);
		
	// Main loop
	while (aptMainLoop())
	{
		//gspWaitForVBlank();

		// Example rendering code that displays a white pixel
		// Please note that the 3DS screens are sideways (thus 240x400 and 240x320)
		u8* fb = gfxGetFramebuffer(GFX_TOP, GFX_LEFT, NULL, NULL);
		fb += offset;
		//memset(fb, 0, 240*400*3);
		
		if(SetKeyState() < 0)
			break;
		g_pGameBoy->SetKeyState(0, g_Key[0]);
		
		GameLoop(fb);
		
		
		//bottom screen
		u8* fbb = gfxGetFramebuffer(GFX_BOTTOM, GFX_LEFT, NULL, NULL);
		CFont8 font(fbb,text_clr);
		font.DrawString(100,0,"\t\tNomadGB, a GameBoy emulator.\n\t\tMade by Vincent(c_gao). \
		\n\t\tBLOG: http://blog.congao.net\n\t\te-mail: dr.c.gao@gmail.com");
		
		
		// Flush and swap framebuffers
		//gfxFlushBuffers();
		//gfxSwapBuffers();
		
		
		//wait & swap
		gfxSwapBuffersGpu();
		gspWaitForEvent(GSPEVENT_VBlank0, false);
	}
	
	// Exit services
	gfxExit();
	hidExit();
	aptExit();
	srvExit();
	return 0;
}
